## Measure Group

Measure groups allow to create a cube made of multiple fact tables.




### Description

A measure group contains the measures associated to the underlying fact tables. Different measure groups may transparently combined within a single MDX select statement (see the following examples for more details).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Simple example

</div>

<div class="ic3-mdx-example-body" style="display:none">

Measure groups allow to combine on a same request [Measure] belonging to different fact tables.

In our example, we are taking the FX for the [EUR] to apply it to the amounts.

**Query**

```
WITH
    MEMBER amountUSD AS [Measures].[Amount] * 1.0, FORMAT_STRING='fixed'
    MEMBER amountEUR AS [Measures].[Amount] * ([Currency].[European Union Currency], [Measures].[FX], [Time].[May 2010]), FORMAT_STRING='fixed'
SELECT
  {amountUSD} + {amountEUR}  on 0,
  {Descendants([Geography].[Geo].[Europe])} on 1
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">amountUSD</td>
  <td class="ic3-mdx-result-cell-header">amountEUR</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255.00</td>
 <td>275.91</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4.00</td>
 <td>4.33</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td>4.00</td>
 <td>4.33</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3.00</td>
 <td>3.25</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td>2.00</td>
 <td>2.16</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td>1.00</td>
 <td>1.08</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Valencia</td>
 <td></td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248.00</td>
 <td>268.34</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td>128.00</td>
 <td>138.50</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td>56.00</td>
 <td>60.59</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td>64.00</td>
 <td>69.25</td>
</tr>
</table>



 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
